// DatabaseMessage.cpp starts

#include <Messenger.h>
#include <strings.h>
#include <String.h>
#include <stdio.h>

#include "Debug.h"
#include "DatabaseMessage.h"
/* Class for sending messages to Database
 */

BMessage *DatabaseMessage::GetRatSettings()
{
	BMessage msg(DBMSG_GET_RAT_SETTINGS);
	BMessage reply;
	status_t status;
	BMessage *result = NULL;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) db, &status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::GetRatSettings: Error creating messenger: ", strerror(status));
	}
	
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::GetRatSettings: Error sending message");
	}
	
	result = new BMessage();
	if ((status = reply.FindMessage("settings", result)) != B_OK) {
		Debug('e', "DatabaseMessage::GetRatSettings: Error decoding reply: ", strerror(status));
		delete result;
		result = NULL;
	}
	
	delete messenger;
	
	return result;
}

void DatabaseMessage::SetRatSettings(BMessage *settings)
{
	BMessage msg(DBMSG_SET_RAT_SETTINGS);
	BMessage reply;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) db, &status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::SetRatSettings: Error creating messenger: ", strerror(status));
	}
	
	msg.AddMessage("settings", settings);
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::SetRatSettings: Error sending message");
	}
	
	if (! reply.IsReply()) {
		Debug('e', "DatabaseMessage::SetRatSettings: Message was NOT a reply!!!!");
	}
	
	delete messenger;
}

BMessage *DatabaseMessage::GetExperimenterSettings()
{
	BMessage msg(DBMSG_GET_EXPERIMENTER_SETTINGS);
	BMessage reply;
	status_t status;
	BMessage *result = NULL;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) db, &status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::GetExperimenterSettings: Error creating messenger: ", strerror(status));
	}
	
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::GetExperimenterSettings: Error sending message");
	}
	
	result = new BMessage();
	if ((status = reply.FindMessage("settings", result)) != B_OK) {
		Debug('e', "DatabaseMessage::GetExperimenterSettings: Error decoding reply: ", strerror(status));
		delete result;
		result = new BMessage(); // put it in known state, with no data fields
	}
	
	delete messenger;
	
	return result;
}

void DatabaseMessage::SetExperimenterSettings(BMessage *settings)
{
	BMessage msg(DBMSG_SET_EXPERIMENTER_SETTINGS);
	BMessage reply;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) db, &status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::SetExperimenterSettings: Error creating messenger: ", strerror(status));
	}
	
	msg.AddMessage("settings", settings);
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::SetExperimenterSettings: Error sending message");
	}
	
	if (! reply.IsReply()) {
		Debug('e', "DatabaseMessage::SetExperimenterSettings: Message was NOT a reply!!!!");
	}
	
	delete messenger;
}


void DatabaseMessage::AddRecord(BMessage *record)
{
	BMessage msg(DBMSG_ADD_RECORD);
	BMessage reply;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) db, &status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::AddRecord: Error creating messenger: ", strerror(status));
	}
	
	msg.AddMessage("record", record);
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::AddRecord: Error sending message");
	}
	
	if (! reply.IsReply()) {
		Debug('e', "DatabaseMessage::AddRecord: Message was NOT a reply!!!!");
	}
	
	delete messenger;
}

int DatabaseMessage::GetNumberOfRecords(BMessage *condition)
{
	BMessage msg(DBMSG_GET_NUMBER_OF_RECORDS);
	BMessage reply;
	status_t status;
	int32 result = 0;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) db, &status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::GetNumberOfRecords: Error creating messenger: ", strerror(status));
	}
	
	msg.AddMessage("condition", condition);
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::GetNumberOfRecords: Error sending message");
	}
	
	if ((status = reply.FindInt32("numberOfRecords", &result)) != B_OK) {
		Debug('e', "DatabaseMessage::GetNumberOfRecords: Error decoding reply: ", strerror(status));
		result = 0; // put in known state
	}
	
	delete messenger;
	
	return result;
}

int DatabaseMessage::GetCurrentRatNumber()
{
	BMessage msg(DBMSG_GET_CURRENT_RAT_NUMBER);
	BMessage reply;
	status_t status;
	int16 result = 0;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) db, &status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::GetCurrentRatNumber: Error creating messenger: ", strerror(status));
	}
	
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::GetCurrentRatNumber: Error sending message");
	}
	
	if ((status = reply.FindInt16("currentRatNumber", &result)) != B_OK) {
		Debug('e', "DatabaseMessage::GetCurrentRatNumber: Error decoding reply: ", strerror(status));
		result = 0; // put in known state
	}
	
	delete messenger;
	
	return result;
}

void DatabaseMessage::SetCurrentRatNumber(int ratNo)
{
	BMessage msg(DBMSG_SET_CURRENT_RAT_NUMBER);
	BMessage reply;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) db, &status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::SetCurrentRatNumber: Error creating messenger: ", strerror(status));
	}
	
	msg.AddInt16("currentRatNumber", ratNo);
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::SetCurrentRatNumber: Error sending message");
	}
	
	if (! reply.IsReply()) {
		Debug('e', "DatabaseMessage::SetCurrentRatNumber: Message was NOT a reply!!!!");
	}
	
	delete messenger;
}

BMessage *DatabaseMessage::GetPerfMonSettings()
{
	BMessage msg(DBMSG_GET_PERF_MON_SETTINGS);
	BMessage reply;
	status_t status;
	BMessage *result = NULL;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) db, &status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::GetPerfMonSettings: Error creating messenger: ", strerror(status));
	}
	
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::GetPerfMonSettings: Error sending message");
	}
	
	result = new BMessage();
	if ((status = reply.FindMessage("settings", result)) != B_OK) {
		Debug('e', "DatabaseMessage::GetPerfMonSettings: Error decoding reply: ", strerror(status));
		delete result;
		result = new BMessage(); // put it in known state, with no data fields
	}
	
	delete messenger;
	
	return result;
}

void DatabaseMessage::SetPerfMonSettings(BMessage *settings)
{
	BMessage msg(DBMSG_SET_PERF_MON_SETTINGS);
	BMessage reply;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) db, &status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::SetPerfMonSettings: Error creating messenger: ", strerror(status));
	}
	
	msg.AddMessage("settings", settings);
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::SetPerfMonSettings: Error sending message");
	}
	
	if (! reply.IsReply()) {
		Debug('e', "DatabaseMessage::SetPerfMonSettings: Message was NOT a reply!!!!");
	}
	
	delete messenger;
}

const char *DatabaseMessage::GetPluginName(char *PluginType)
{
	BMessage msg(DBMSG_GET_PLUGIN_NAME);
	BMessage reply;
	status_t status;
	static BString name;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) db, &status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::GetPluginName: Error creating messenger: ", strerror(status));
	}
	
	msg.AddString("pluginType", PluginType);
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::GetPluginName: Error sending message");
	}
	
	if ((status = reply.FindString("pluginName", &name)) != B_OK) {
		Debug('e', "DatabaseMessage::GetPluginName: Error decoding reply: ", strerror(status));
	}
	
	delete messenger;
	
	return name.String();
}

void DatabaseMessage::SetPluginName(char *PluginType, char *name)
{
	BMessage msg(DBMSG_SET_PLUGIN_NAME);
	BMessage reply;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) db, &status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::SetPluginName: Error creating messenger: ", strerror(status));
	}
	
	msg.AddString("pluginType", PluginType);
	msg.AddString("pluginName", name);
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::SetPluginName: Error sending message");
	}
	
	if (! reply.IsReply()) {
		Debug('e', "DatabaseMessage::SetPluginName: Message was NOT a reply!!!!");
	}
	
	delete messenger;
}

void DatabaseMessage::DBExport()
{
	BMessage msg(DBMSG_DATABASE_EXPORT);
	BMessage reply;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) db, &status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::DBExport: Error creating messenger: ", strerror(status));
	}
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::DBExport: Error sending message");
	}
	
	if (! reply.IsReply()) {
		Debug('e', "DatabaseMessage::DBExport: Message was NOT a reply!!!!");
	}
	
	delete messenger;
}	

void DatabaseMessage::DBImport()
{
	BMessage msg(DBMSG_DATABASE_IMPORT);
	BMessage reply;
	status_t status;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *) db, &status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::DBImport: Error creating messenger: ", strerror(status));
	}
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::DBImport: Error sending message");
	}
	
	if (! reply.IsReply()) {
		Debug('e', "DatabaseMessage::DBImport: Message was NOT a reply!!!!");
	}
	
	delete messenger;
}	

int DatabaseMessage::GetNumberOfRats()
{
	BMessage msg(DBMSG_GET_N_RATS);
	BMessage reply;
	status_t status;
	int16 numberOfRats;
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *)db,&status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::GetNumberOfRats: Error creating messenger: ", strerror(status));
	}
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::GetNumberOfRats: Error sending message");
	}
	if (! reply.IsReply()) {
		Debug('e', "DatabaseMessage::GetNumberOfRats: Message was NOT a reply!!!!");
	}
	reply.FindInt16("n_rats",&numberOfRats);
	delete messenger;
	return (int)numberOfRats;
	
}	


void DatabaseMessage::SetNumberOfRats(int n)
{
	BMessage msg(DBMSG_SET_N_RATS);
	BMessage reply;
	status_t status;
	
	msg.AddInt16("n_rats",(int16) n);	
	
	BMessenger *messenger = new BMessenger(NULL, (BLooper *)db,&status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::SetNumberOfRats: Error creating messenger: ", strerror(status));
	}
	
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::SetNumberOfRats: Error sending message");
	}
	if (! reply.IsReply()) {
		Debug('e', "DatabaseMessage::SetNumberOfRats: Message was NOT a reply!!!!");
	}
	
	delete messenger;
}	
	
void DatabaseMessage::DBSave(BFile *file)
{
	Debug('t',"DatabaseMessage::DBSave  im here.");
	BMessage msg(DBMSG_DB_SAVE);
	BMessage reply;
	status_t status;
	
	msg.AddPointer("file_star",(void *)file);

	BMessenger *messenger = new BMessenger(NULL, (BLooper *)db,&status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::DBSave: Error creating messenger: ", strerror(status));
	}
	
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::DBSave: Error sending message");
	}
	if (! reply.IsReply()) {
		Debug('e', "DatabaseMessage::DBSave: Message was NOT a reply!!!!");
	}
	
	delete messenger;
}	
	


void DatabaseMessage::DBLoad(BFile *file)
{
	Debug('t',"DatabaseMessage::DBLoad  im here.");
	BMessage msg(DBMSG_DB_LOAD);
	BMessage reply;
	status_t status;
	
	msg.AddPointer("file_star",(void *)file);

	BMessenger *messenger = new BMessenger(NULL, (BLooper *)db,&status);
	if (status != B_OK) {
		Debug('e', "DatabaseMessage::DBLoad: Error creating messenger: ", strerror(status));
	}
	
	if (messenger->SendMessage(&msg, &reply) != B_OK) {
		Debug('e', "DatabaseMessage::DBLoad: Error sending message");
	}
	if (! reply.IsReply()) {
		Debug('e', "DatabaseMessage::DBLoad: Message was NOT a reply!!!!");
	}
	
	delete messenger;
}





// DatabaseMessage.cpp ends